/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./src/main/PathArrayParamsEditTool.ts":
/*!*********************************************!*\
  !*** ./src/main/PathArrayParamsEditTool.ts ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PathArrayParamsEditTool: () => (/* binding */ PathArrayParamsEditTool),
/* harmony export */   pathArrayParamsEditTool: () => (/* binding */ pathArrayParamsEditTool)
/* harmony export */ });
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./types */ "./src/main/types.ts");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils */ "./src/main/utils.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};


const design = app.getActiveDesign();
class PathArrayParamsEditTool {
    constructor() {
        this.components = [];
        this.path = [];
        this.pathPointPoses = [];
        this.totalLength = 0;
        this.pathArrayParams = _types__WEBPACK_IMPORTED_MODULE_0__.DefaultPathArrayParams;
    }
    getPathArrayParams() {
        return this.pathArrayParams;
    }
    setModel(model) {
        const groupDefinition = model.getGroupDefinition();
        const components = groupDefinition === null || groupDefinition === void 0 ? void 0 : groupDefinition.getSubGroupInstances().reduce((acc, instance) => {
            const componentProperty = instance.getCustomProperty(_types__WEBPACK_IMPORTED_MODULE_0__.ComponentPropertyKey);
            const index = Number.parseInt(componentProperty);
            if (Number.isFinite(index)) {
                acc.push({ instance, index });
            }
            return acc;
        }, []).sort((a, b) => a.index - b.index);
        if ((components === null || components === void 0 ? void 0 : components.length) && groupDefinition) {
            const countProperty = groupDefinition.getCustomProperty(_types__WEBPACK_IMPORTED_MODULE_0__.CountPropertyKey);
            const count = Number.parseInt(countProperty);
            const intervalProperty = groupDefinition.getCustomProperty(_types__WEBPACK_IMPORTED_MODULE_0__.IntervalPropertyKey);
            const intervalLocked = intervalProperty.startsWith(_types__WEBPACK_IMPORTED_MODULE_0__.ManualPrefix);
            const interval = intervalLocked ? Number.parseFloat(intervalProperty.slice(1)) : Number.parseFloat(intervalProperty);
            const pathAxisProperty = groupDefinition.getCustomProperty(_types__WEBPACK_IMPORTED_MODULE_0__.PathAxisPropertyKey);
            const normalAxisProperty = groupDefinition.getCustomProperty(_types__WEBPACK_IMPORTED_MODULE_0__.NormalAxisPropertyKey);
            const scaleProperty = groupDefinition.getCustomProperty(_types__WEBPACK_IMPORTED_MODULE_0__.ScalePropertyKey);
            const scaleLocked = scaleProperty.startsWith(_types__WEBPACK_IMPORTED_MODULE_0__.ManualPrefix);
            const scale = scaleLocked ? Number.parseFloat(scaleProperty.slice(1)) : Number.parseFloat(scaleProperty);
            if (Number.isFinite(count) && count > 1 && Number.isFinite(interval) && Number.isFinite(scale) && (0,_types__WEBPACK_IMPORTED_MODULE_0__.isAxisValid)(pathAxisProperty) && (0,_types__WEBPACK_IMPORTED_MODULE_0__.isAxisValid)(normalAxisProperty)) {
                const pathListProperty = groupDefinition.getCustomProperty(_types__WEBPACK_IMPORTED_MODULE_0__.PathListPropertyKey);
                const auxiliaryBoundedCurveMap = new Map();
                groupDefinition === null || groupDefinition === void 0 ? void 0 : groupDefinition.getAuxiliaryCurves().forEach(curve => {
                    if ((0,_utils__WEBPACK_IMPORTED_MODULE_1__.isKAuxiliaryBoundedCurve)(curve)) {
                        auxiliaryBoundedCurveMap.set(curve.getKey(), curve);
                    }
                });
                let pathValid = true;
                const path = [];
                for (const pathStr of pathListProperty.split(_types__WEBPACK_IMPORTED_MODULE_0__.PathDelimiter)) {
                    const splitResult = pathStr.split(_types__WEBPACK_IMPORTED_MODULE_0__.PathReversedDelimiter);
                    if (splitResult.length === 2) {
                        const auxiliaryBoundedCurve = auxiliaryBoundedCurveMap.get(splitResult[0]);
                        if (auxiliaryBoundedCurve) {
                            path.push({ curve: auxiliaryBoundedCurve, reversed: splitResult[1] === '1' });
                            continue;
                        }
                    }
                    pathValid = false;
                    break;
                }
                if (pathValid && path.length) {
                    this.model = model;
                    this.components = components;
                    this.path = path;
                    const { pathPointPoses, totalLength } = this.pathPointPoses.length ? { pathPointPoses: this.pathPointPoses, totalLength: this.totalLength } : (0,_utils__WEBPACK_IMPORTED_MODULE_1__.generatePathPoses)(this.path);
                    this.pathPointPoses = pathPointPoses;
                    this.totalLength = totalLength;
                    this.pathArrayParams = {
                        interval: { value: interval, min: 10, max: totalLength / (count - 1) },
                        intervalLocked,
                        count: { value: count, min: 1, max: intervalLocked ? Math.floor(totalLength / interval + 1) : 1000 },
                        pathAxis: pathAxisProperty,
                        normalAxis: normalAxisProperty,
                        scale: { value: scale, min: 0.01, max: 1000 },
                        scaleLocked
                    };
                    return true;
                }
            }
        }
        return false;
    }
    clearModel() {
        this.model = undefined;
        this.path = [];
        this.components = [];
        this.pathPointPoses = [];
        this.totalLength = 0;
        this.pathArrayParams = _types__WEBPACK_IMPORTED_MODULE_0__.DefaultPathArrayParams;
    }
    doOperation(params, needTransform = true) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            if (!this.model)
                return false;
            const { pathPointPoses, totalLength } = this.pathPointPoses.length ? { pathPointPoses: this.pathPointPoses, totalLength: this.totalLength } : (0,_utils__WEBPACK_IMPORTED_MODULE_1__.generatePathPoses)(this.path);
            this.pathPointPoses = pathPointPoses;
            this.totalLength = totalLength;
            const componentTransforms = (0,_utils__WEBPACK_IMPORTED_MODULE_1__.getTransformFromPathPointPoses)(pathPointPoses, params);
            // const scaleMatrix = GeomLib.createScaleMatrix4(scale, scale, scale);
            let operationSuccess = (yield design.activateGroupInstance(this.model)).isSuccess;
            if (needTransform) {
                for (const component of this.components) {
                    if (component.index >= params.count.value)
                        break;
                    const componentTransform = component.instance.getTransform();
                    const componentLocalBoundingBox = component.instance.getLocalBoundingBox();
                    const componentPosition = componentLocalBoundingBox.center;
                    const resetMatrix = GeomLib.createTranslationMatrix4(-componentPosition.x, -componentPosition.y, -componentPosition.z)
                        .multiplied(componentTransform.inversed());
                    const transformResult = design.transformGroupInstances([component.instance], componentTransforms[component.index].multiplied(resetMatrix));
                    if (!transformResult.isSuccess) {
                        operationSuccess = false;
                        break;
                    }
                }
            }
            if (params.count.value > this.pathArrayParams.count.value) {
                const componentInstance = this.components[0].instance;
                const componentTransform = componentInstance.getTransform();
                const componentLocalBoundingBox = componentInstance.getLocalBoundingBox();
                const componentPosition = componentLocalBoundingBox.center;
                const baseTransformInverse = GeomLib.createTranslationMatrix4(-componentPosition.x, -componentPosition.y, -componentPosition.z)
                    .multiplied(componentTransform.inversed());
                const newGroupInstances = (_a = design.bulkCopyGroupInstances([componentInstance], [componentTransforms.slice(this.pathArrayParams.count.value).map(matrix => matrix.multiplied(baseTransformInverse))])) === null || _a === void 0 ? void 0 : _a.addedInstances;
                if (newGroupInstances === null || newGroupInstances === void 0 ? void 0 : newGroupInstances.length) {
                    for (let index = this.pathArrayParams.count.value; index < params.count.value; index++) {
                        operationSuccess = operationSuccess && newGroupInstances[index - this.pathArrayParams.count.value].setCustomProperty(_types__WEBPACK_IMPORTED_MODULE_0__.ComponentPropertyKey, `${index}`).isSuccess;
                    }
                    if (operationSuccess) {
                        this.components = [...this.components, ...newGroupInstances.map((instance, i) => { return { instance, index: this.pathArrayParams.count.value + i }; })];
                    }
                }
                else {
                    operationSuccess = false;
                }
            }
            else if (params.count.value < this.pathArrayParams.count.value) {
                const componentIndex = this.components.findIndex(component => component.index === params.count.value);
                const toDeleteComponents = this.components.slice(componentIndex);
                for (const toDeleteComponent of toDeleteComponents) {
                    operationSuccess = operationSuccess && design.removeGroupInstance(toDeleteComponent.instance).isSuccess;
                }
                if (operationSuccess) {
                    this.components.splice(componentIndex, this.components.length - componentIndex + 1);
                }
            }
            operationSuccess = operationSuccess && (yield design.deactivateGroupInstance()).isSuccess;
            app.getSelection().add([this.model]);
            return operationSuccess;
        });
    }
    updateInterval(newInterval) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const modelGroupDefinition = (_a = this.model) === null || _a === void 0 ? void 0 : _a.getGroupDefinition();
            if (this.model && modelGroupDefinition && this.components.length && this.path.length && this.pathArrayParams && newInterval !== this.pathArrayParams.interval.value) {
                const { scale, count, scaleLocked } = this.pathArrayParams;
                const componentInstance = this.components[0].instance;
                const componentLocalBoundingBox = componentInstance.getLocalBoundingBox();
                const needNewCount = newInterval * count.value > this.totalLength;
                const newCount = needNewCount ? Math.floor(this.totalLength / newInterval + 1) : count.value;
                const actualScale = scaleLocked ? scale.value : (componentLocalBoundingBox.width > (newInterval / 2) ? (newInterval / 2 / componentLocalBoundingBox.width) : scale.value);
                design.startOperation();
                const newParams = Object.assign(Object.assign({}, this.pathArrayParams), { interval: { value: newInterval, min: 10, max: this.totalLength / (newCount - 1) }, intervalLocked: true, count: { value: newCount, min: 1, max: Math.floor(this.totalLength / newInterval + 1) }, scale: Object.assign(Object.assign({}, scale), { value: actualScale }) });
                const operationSuccess = yield this.doOperation(newParams);
                if (operationSuccess) {
                    modelGroupDefinition.setCustomProperty(_types__WEBPACK_IMPORTED_MODULE_0__.IntervalPropertyKey, `${_types__WEBPACK_IMPORTED_MODULE_0__.ManualPrefix}${newInterval}`);
                    if (!scaleLocked && actualScale !== scale.value) {
                        modelGroupDefinition.setCustomProperty(_types__WEBPACK_IMPORTED_MODULE_0__.ScalePropertyKey, `${actualScale}`);
                    }
                    this.pathArrayParams = newParams;
                    design.commitOperation();
                }
                else {
                    design.abortOperation();
                }
                return operationSuccess;
            }
        });
    }
    updateCount(newCount) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const modelGroupDefinition = (_a = this.model) === null || _a === void 0 ? void 0 : _a.getGroupDefinition();
            if (this.model && modelGroupDefinition && this.components.length && this.path.length && this.pathArrayParams && newCount !== this.pathArrayParams.count.value) {
                const { interval, intervalLocked, count, scale, scaleLocked } = this.pathArrayParams;
                const totalLength = this.pathPointPoses.length ? this.totalLength : (0,_utils__WEBPACK_IMPORTED_MODULE_1__.generatePathPoses)(this.path).totalLength;
                this.totalLength = totalLength;
                const componentInstance = this.components[0].instance;
                const componentLocalBoundingBox = componentInstance.getLocalBoundingBox();
                const needNewInterval = (newCount > count.value && (this.totalLength > interval.value * newCount)) || (newCount < count.value && !intervalLocked);
                const actualInterval = needNewInterval ? this.totalLength / (newCount - 1) : interval.value;
                const needNewScale = needNewInterval || (!scaleLocked && componentLocalBoundingBox.width > (actualInterval / 2));
                const actualScale = needNewScale ? (actualInterval / 2 / componentLocalBoundingBox.width) : scale.value;
                design.startOperation();
                const newParams = Object.assign(Object.assign({}, this.pathArrayParams), { interval: { value: actualInterval, min: 10, max: totalLength / (newCount - 1) }, count: Object.assign(Object.assign({}, this.pathArrayParams.count), { value: newCount }), scale: Object.assign(Object.assign({}, this.pathArrayParams.scale), { value: actualScale }) });
                const operationSuccess = yield this.doOperation(newParams, needNewInterval || needNewScale);
                if (operationSuccess) {
                    modelGroupDefinition.setCustomProperty(_types__WEBPACK_IMPORTED_MODULE_0__.CountPropertyKey, `${newCount}`);
                    if (needNewInterval) {
                        modelGroupDefinition.setCustomProperty(_types__WEBPACK_IMPORTED_MODULE_0__.IntervalPropertyKey, `${actualInterval}`);
                    }
                    if (needNewScale) {
                        modelGroupDefinition.setCustomProperty(_types__WEBPACK_IMPORTED_MODULE_0__.ScalePropertyKey, `${scaleLocked ? _types__WEBPACK_IMPORTED_MODULE_0__.ManualPrefix : ''}${actualScale}`);
                    }
                    this.pathArrayParams = newParams;
                    design.commitOperation();
                }
                else {
                    design.abortOperation();
                }
                return operationSuccess;
            }
        });
    }
    updatePathAxis(newPathAxis) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const modelGroupDefinition = (_a = this.model) === null || _a === void 0 ? void 0 : _a.getGroupDefinition();
            if (this.model && modelGroupDefinition && this.components.length && this.path.length && this.pathArrayParams) {
                design.startOperation();
                const newParams = Object.assign(Object.assign({}, this.pathArrayParams), { pathAxis: newPathAxis });
                const operationSuccess = yield this.doOperation(newParams);
                if (operationSuccess) {
                    modelGroupDefinition.setCustomProperty(_types__WEBPACK_IMPORTED_MODULE_0__.PathAxisPropertyKey, `${newPathAxis}`);
                    this.pathArrayParams = newParams;
                    design.commitOperation();
                }
                else {
                    design.abortOperation();
                }
                return operationSuccess;
            }
        });
    }
    updateNormalAxis(newNormalAxis) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const modelGroupDefinition = (_a = this.model) === null || _a === void 0 ? void 0 : _a.getGroupDefinition();
            if (this.model && modelGroupDefinition && this.components.length && this.path.length && this.pathArrayParams) {
                design.startOperation();
                const newParams = Object.assign(Object.assign({}, this.pathArrayParams), { normalAxis: newNormalAxis });
                const operationSuccess = yield this.doOperation(newParams);
                if (operationSuccess) {
                    modelGroupDefinition.setCustomProperty(_types__WEBPACK_IMPORTED_MODULE_0__.NormalAxisPropertyKey, `${newNormalAxis}`);
                    this.pathArrayParams = newParams;
                    design.commitOperation();
                }
                else {
                    design.abortOperation();
                }
                return operationSuccess;
            }
        });
    }
    updateScale(newScale) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const modelGroupDefinition = (_a = this.model) === null || _a === void 0 ? void 0 : _a.getGroupDefinition();
            if (this.model && modelGroupDefinition && this.components.length && this.path.length && this.pathArrayParams && newScale !== this.pathArrayParams.scale.value) {
                design.startOperation();
                const newParams = Object.assign(Object.assign({}, this.pathArrayParams), { scale: Object.assign(Object.assign({}, this.pathArrayParams.scale), { value: newScale }), scaleLocked: true });
                const operationSuccess = yield this.doOperation(newParams);
                if (operationSuccess) {
                    modelGroupDefinition.setCustomProperty(_types__WEBPACK_IMPORTED_MODULE_0__.ScalePropertyKey, `${_types__WEBPACK_IMPORTED_MODULE_0__.ManualPrefix}${newScale}`);
                    this.pathArrayParams = newParams;
                    design.commitOperation();
                }
                else {
                    design.abortOperation();
                }
                return operationSuccess;
            }
        });
    }
    onToolActive() {
    }
    onToolDeactive() {
    }
    onMouseMove(event, inferenceResult) {
    }
    onLButtonUp(event, inferenceResult) {
    }
    onRButtonUp(event, inferenceResult) {
        app.deactivateCustomTool(this);
    }
    onLButtonDbClick(event, inferenceResult) {
        ;
    }
    allowUsingInference() {
        return false;
    }
    onKeyDown(event) {
        ;
    }
    onKeyUp(event) {
        ;
    }
}
const pathArrayParamsEditTool = new PathArrayParamsEditTool();


/***/ }),

/***/ "./src/main/PathArrayTool.ts":
/*!***********************************!*\
  !*** ./src/main/PathArrayTool.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   PathArrayTool: () => (/* binding */ PathArrayTool),
/* harmony export */   pathArrayTool: () => (/* binding */ pathArrayTool)
/* harmony export */ });
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./types */ "./src/main/types.ts");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils */ "./src/main/utils.ts");


class PathArrayTool {
    constructor() {
        this.path = [];
        this.pathPointPoses = [];
        this.totalLength = 0;
        this.pathArrayParams = _types__WEBPACK_IMPORTED_MODULE_0__.DefaultPathArrayParams;
    }
    onToolActive() {
        const selection = app.getSelection();
        const toolHelper = app.getToolHelper();
        toolHelper.enablePicking(true);
        toolHelper.setDefaultSelectBehavior(KSelectBehavior.ADD);
        const allEntities = selection.getAllEntities();
        if (allEntities.length === 1 && ((0,_utils__WEBPACK_IMPORTED_MODULE_1__.isKGroupInstance)(allEntities[0]) || (0,_utils__WEBPACK_IMPORTED_MODULE_1__.isKFace)(allEntities[0]))) {
            this.model = allEntities[0];
        }
        else {
            selection.clear();
        }
    }
    onToolDeactive() {
        const pluginUI = app.getPluginUI();
        this.tryCommit();
        pluginUI.postMessage({ type: 'leavePathArrayTool' }, '*');
        const toolHelper = app.getToolHelper();
        toolHelper.enablePicking(false);
        toolHelper.setDefaultSelectBehavior(KSelectBehavior.REPLACE);
    }
    onMouseMove(event, inferenceResult) {
        const entity = inferenceResult === null || inferenceResult === void 0 ? void 0 : inferenceResult.entity;
        console.log(entity);
    }
    onLButtonUp(event, inferenceResult) {
        const selection = app.getSelection();
        const pickHelper = app.getPickHelper();
        // const pickableEntityType = this.model ? [KEntityType.AuxiliaryBoundedCurve] : [KAppEntityType.GroupInstance, KEntityType.Face];
        const allPickedEntities = pickHelper.pickByPoint(event.clientX(), event.clientY()).getAllPicked();
        if (allPickedEntities.length) {
            if (this.model) {
                let isValidPath = false;
                if ((0,_utils__WEBPACK_IMPORTED_MODULE_1__.isKAuxiliaryBoundedCurve)(allPickedEntities[0])) {
                    const auxiliaryBoundedCurve = allPickedEntities[0];
                    if (this.path.length) {
                        const lastPath = this.path[this.path.length - 1];
                        let pathEndVertex = lastPath.reversed ? lastPath.curve.getStartVertex() : lastPath.curve.getEndVertex();
                        let connectionResult;
                        if (this.path.length === 1) {
                            connectionResult = (0,_utils__WEBPACK_IMPORTED_MODULE_1__.boundedCurveConnectionDetect)(pathEndVertex, auxiliaryBoundedCurve);
                            if (!connectionResult.connected) {
                                pathEndVertex = lastPath.curve.getStartVertex();
                                connectionResult = (0,_utils__WEBPACK_IMPORTED_MODULE_1__.boundedCurveConnectionDetect)(pathEndVertex, auxiliaryBoundedCurve);
                                if (connectionResult.connected) {
                                    lastPath.reversed = !lastPath.reversed;
                                }
                            }
                        }
                        else {
                            connectionResult = (0,_utils__WEBPACK_IMPORTED_MODULE_1__.boundedCurveConnectionDetect)(pathEndVertex, auxiliaryBoundedCurve);
                        }
                        if (connectionResult.connected) {
                            this.path.push({ curve: auxiliaryBoundedCurve, reversed: connectionResult.reversed });
                            isValidPath = true;
                        }
                    }
                    else {
                        this.path.push({ curve: auxiliaryBoundedCurve, reversed: false });
                        isValidPath = true;
                    }
                }
                if (isValidPath) {
                    selection.remove(allPickedEntities.slice(1));
                }
                else {
                    selection.remove(allPickedEntities);
                }
            }
            else {
                this.model = allPickedEntities[0];
            }
        }
        else {
            this.tryCommit();
        }
    }
    tryCommit() {
        var _a, _b, _c;
        if (this.model && this.path.length) {
            const design = app.getActiveDesign();
            design.startOperation();
            let component;
            if ((0,_utils__WEBPACK_IMPORTED_MODULE_1__.isKGroupInstance)(this.model)) {
                component = this.model;
            }
            else if ((0,_utils__WEBPACK_IMPORTED_MODULE_1__.isKFace)(this.model)) {
                component = (_a = design.makeGroup([this.model], [], [])) === null || _a === void 0 ? void 0 : _a.addedInstance;
            }
            if (component) {
                const { pathPointPoses, totalLength } = this.pathPointPoses.length ? { pathPointPoses: this.pathPointPoses, totalLength: this.totalLength } : (0,_utils__WEBPACK_IMPORTED_MODULE_1__.generatePathPoses)(this.path);
                this.pathPointPoses = pathPointPoses;
                this.totalLength = totalLength;
                const components = [component];
                const automaticInterval = totalLength / (this.pathArrayParams.count.value - 1);
                const worldSize = (0,_utils__WEBPACK_IMPORTED_MODULE_1__.getBoundingBoxSizeInWorld)(component);
                const scale = worldSize[0] > (automaticInterval / 2) ? (automaticInterval / 2 / worldSize[0]) : 1;
                const componentLocalBoundingBox = component.getLocalBoundingBox();
                const componentTransform = component.getTransform();
                const componentPosition = componentLocalBoundingBox.center;
                const resetMatrix = GeomLib.createTranslationMatrix4(-componentPosition.x, -componentPosition.y, -componentPosition.z)
                    .multiplied(componentTransform.inversed());
                const newPathArrayParams = Object.assign(Object.assign({}, this.pathArrayParams), { interval: Object.assign(Object.assign({}, this.pathArrayParams.interval), { value: automaticInterval }), scale: Object.assign(Object.assign({}, this.pathArrayParams.scale), { value: scale }) });
                const componentTransforms = (0,_utils__WEBPACK_IMPORTED_MODULE_1__.getTransformFromPathPointPoses)(this.pathPointPoses, newPathArrayParams);
                let operationSuccess = design.transformGroupInstances([component], componentTransforms[0].multiplied(resetMatrix)).isSuccess;
                if (operationSuccess) {
                    const baseTransformInverse = componentTransforms[0].inversed();
                    const newComponents = (_b = design.bulkCopyGroupInstances([component], [componentTransforms.slice(1).map(matrix => matrix.multiplied(baseTransformInverse))])) === null || _b === void 0 ? void 0 : _b.addedInstances;
                    if (newComponents === null || newComponents === void 0 ? void 0 : newComponents.length) {
                        components.push(...newComponents);
                        for (let index = 0; index < components.length; index++) {
                            operationSuccess = operationSuccess && components[index].setCustomProperty(_types__WEBPACK_IMPORTED_MODULE_0__.ComponentPropertyKey, `${index}`).isSuccess;
                        }
                        const parentGroupInstance = (_c = design.makeGroup([], components, this.path.map(pathObject => pathObject.curve))) === null || _c === void 0 ? void 0 : _c.addedInstance;
                        const parentGroupDefinition = parentGroupInstance === null || parentGroupInstance === void 0 ? void 0 : parentGroupInstance.getGroupDefinition();
                        if (parentGroupDefinition && parentGroupInstance) {
                            const pathCount = this.path.length;
                            operationSuccess = operationSuccess && parentGroupDefinition.setCustomProperty(_types__WEBPACK_IMPORTED_MODULE_0__.IntervalPropertyKey, `${automaticInterval}`).isSuccess;
                            operationSuccess = operationSuccess && parentGroupDefinition.setCustomProperty(_types__WEBPACK_IMPORTED_MODULE_0__.CountPropertyKey, `${this.pathArrayParams.count.value}`).isSuccess;
                            operationSuccess = operationSuccess && parentGroupDefinition.setCustomProperty(_types__WEBPACK_IMPORTED_MODULE_0__.PathAxisPropertyKey, `${this.pathArrayParams.pathAxis}`).isSuccess;
                            operationSuccess = operationSuccess && parentGroupDefinition.setCustomProperty(_types__WEBPACK_IMPORTED_MODULE_0__.NormalAxisPropertyKey, `${this.pathArrayParams.normalAxis}`).isSuccess;
                            operationSuccess = operationSuccess && parentGroupDefinition.setCustomProperty(_types__WEBPACK_IMPORTED_MODULE_0__.ScalePropertyKey, `${scale}`).isSuccess;
                            const newPath = (0,_utils__WEBPACK_IMPORTED_MODULE_1__.findPathAfterMakeGroup)(this.path, parentGroupInstance);
                            operationSuccess = operationSuccess && (newPath === null || newPath === void 0 ? void 0 : newPath.length) === this.path.length;
                            if (operationSuccess && (newPath === null || newPath === void 0 ? void 0 : newPath.length)) {
                                this.path = newPath;
                            }
                            operationSuccess = operationSuccess && parentGroupDefinition.setCustomProperty(_types__WEBPACK_IMPORTED_MODULE_0__.PathListPropertyKey, this.path.reduce((acc, pathObject, index) => {
                                acc += `${pathObject.curve.getKey()}${_types__WEBPACK_IMPORTED_MODULE_0__.PathReversedDelimiter}${pathObject.reversed ? 1 : 0}`;
                                if (index < pathCount - 1) {
                                    acc += `${_types__WEBPACK_IMPORTED_MODULE_0__.PathDelimiter}`;
                                }
                                return acc;
                            }, '')).isSuccess;
                            if (operationSuccess) {
                                this.pathArrayParams = newPathArrayParams;
                                design.commitOperation();
                                const selection = app.getSelection();
                                selection.clear();
                                selection.add([parentGroupInstance]);
                            }
                            else {
                                design.abortOperation();
                            }
                        }
                        else {
                            design.abortOperation();
                        }
                    }
                    else {
                        design.abortOperation();
                    }
                }
                app.deactivateCustomTool(this, false);
            }
            else {
                design.abortOperation();
            }
        }
        this.clear();
    }
    clear() {
        this.model = undefined;
        this.path = [];
        this.pathPointPoses = [];
        this.totalLength = 0;
        this.pathArrayParams = Object.assign(Object.assign({}, _types__WEBPACK_IMPORTED_MODULE_0__.DefaultPathArrayParams), { count: this.pathArrayParams.count });
    }
    onRButtonUp(event, inferenceResult) {
        app.deactivateCustomTool(this);
    }
    onLButtonDbClick(event, inferenceResult) {
        ;
    }
    allowUsingInference() {
        return true;
    }
    onKeyDown(event) {
        ;
    }
    onKeyUp(event) {
        ;
    }
}
const pathArrayTool = new PathArrayTool();


/***/ }),

/***/ "./src/main/types.ts":
/*!***************************!*\
  !*** ./src/main/types.ts ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ComponentPropertyKey: () => (/* binding */ ComponentPropertyKey),
/* harmony export */   CountPropertyKey: () => (/* binding */ CountPropertyKey),
/* harmony export */   DefaultPathArrayParams: () => (/* binding */ DefaultPathArrayParams),
/* harmony export */   IntervalPropertyKey: () => (/* binding */ IntervalPropertyKey),
/* harmony export */   ManualPrefix: () => (/* binding */ ManualPrefix),
/* harmony export */   NormalAxisPropertyKey: () => (/* binding */ NormalAxisPropertyKey),
/* harmony export */   PathAxisPropertyKey: () => (/* binding */ PathAxisPropertyKey),
/* harmony export */   PathDelimiter: () => (/* binding */ PathDelimiter),
/* harmony export */   PathListPropertyKey: () => (/* binding */ PathListPropertyKey),
/* harmony export */   PathReversedDelimiter: () => (/* binding */ PathReversedDelimiter),
/* harmony export */   ScalePropertyKey: () => (/* binding */ ScalePropertyKey),
/* harmony export */   dummyMatrix4: () => (/* binding */ dummyMatrix4),
/* harmony export */   dummyPoint3d: () => (/* binding */ dummyPoint3d),
/* harmony export */   dummyVector3d: () => (/* binding */ dummyVector3d),
/* harmony export */   isAxisValid: () => (/* binding */ isAxisValid)
/* harmony export */ });
const ComponentPropertyKey = 'PAComponent';
const IntervalPropertyKey = 'PAInterval';
const CountPropertyKey = 'PACount';
const PathAxisPropertyKey = 'PAPathAxis';
const NormalAxisPropertyKey = 'PANormalAxis';
const ScalePropertyKey = 'PAScale';
const PathListPropertyKey = 'PAPathList';
const PathReversedDelimiter = '-';
const PathDelimiter = '&';
const ManualPrefix = 'm';
function isAxisValid(axis) {
    return axis === "X" /* Axis.X */ || axis === "-X" /* Axis.XMinus */ || axis === "Y" /* Axis.Y */ || axis === "-Y" /* Axis.YMinus */ || axis === "Z" /* Axis.Z */ || axis === "-Z" /* Axis.ZMinus */;
}
const DefaultPathArrayParams = {
    interval: { value: 1000, min: 10, max: 9999999 },
    count: { value: 5, min: 1, max: 100 },
    pathAxis: "X" /* Axis.X */,
    normalAxis: "Z" /* Axis.Z */,
    scale: { value: 1, min: 0.01, max: 1000 },
};
const dummyMatrix4 = GeomLib.createIdentityMatrix4();
const dummyVector3d = GeomLib.createVector3d(0, 0, 1);
const dummyPoint3d = GeomLib.createPoint3d(0, 0, 0);


/***/ }),

/***/ "./src/main/utils.ts":
/*!***************************!*\
  !*** ./src/main/utils.ts ***!
  \***************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   boundedCurveConnectionDetect: () => (/* binding */ boundedCurveConnectionDetect),
/* harmony export */   discreteAuxiliaryBoundedCurve: () => (/* binding */ discreteAuxiliaryBoundedCurve),
/* harmony export */   findPathAfterMakeGroup: () => (/* binding */ findPathAfterMakeGroup),
/* harmony export */   generatePathPoses: () => (/* binding */ generatePathPoses),
/* harmony export */   getAuxiliaryBoundedCurveNormal: () => (/* binding */ getAuxiliaryBoundedCurveNormal),
/* harmony export */   getBoundingBoxSizeInWorld: () => (/* binding */ getBoundingBoxSizeInWorld),
/* harmony export */   getExtendedTransform: () => (/* binding */ getExtendedTransform),
/* harmony export */   getNormalByX: () => (/* binding */ getNormalByX),
/* harmony export */   getTransformFromPathPointPoses: () => (/* binding */ getTransformFromPathPointPoses),
/* harmony export */   isKArc3d: () => (/* binding */ isKArc3d),
/* harmony export */   isKAuxiliaryBoundedCurve: () => (/* binding */ isKAuxiliaryBoundedCurve),
/* harmony export */   isKFace: () => (/* binding */ isKFace),
/* harmony export */   isKGroupInstance: () => (/* binding */ isKGroupInstance),
/* harmony export */   isKLineSegment3d: () => (/* binding */ isKLineSegment3d)
/* harmony export */ });
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./types */ "./src/main/types.ts");

function isKGroupInstance(entity) {
    return entity.getType() === KEntityType.GroupInstance;
}
function isKFace(entity) {
    return entity.getType() === KEntityType.Face;
}
function isKAuxiliaryBoundedCurve(entity) {
    return entity.getType() === KEntityType.AuxiliaryBoundedCurve;
}
function isKLineSegment3d(entity) {
    return !!entity.direction;
}
function isKArc3d(entity) {
    return !!entity.circle;
}
function boundedCurveConnectionDetect(auxiliaryVertex, auxiliaryBoundedCurve) {
    const startVertex = auxiliaryBoundedCurve.getStartVertex();
    const endVertex = auxiliaryBoundedCurve.getStartVertex();
    if (startVertex.getKey() === auxiliaryVertex.getKey()) {
        return { connected: true, reversed: false };
    }
    else if (endVertex.getKey() === auxiliaryVertex.getKey()) {
        return { connected: true, reversed: true };
    }
    return { connected: false, reversed: false };
}
function discreteAuxiliaryBoundedCurve(auxiliaryBoundedCurve) {
    const boundedCurve = auxiliaryBoundedCurve.getBoundedCurve();
    let discretePoints = [];
    if (boundedCurve) {
        if (isKLineSegment3d(boundedCurve)) {
            discretePoints = [boundedCurve.startPoint, boundedCurve.endPoint];
        }
        else if (isKArc3d(boundedCurve)) {
            discretePoints = boundedCurve.getApproximatePointsByAngle();
        }
    }
    return discretePoints;
}
function getAuxiliaryBoundedCurveNormal(auxiliaryBoundedCurve) {
    const boundedCurve = auxiliaryBoundedCurve.getBoundedCurve();
    if (boundedCurve) {
        if (isKArc3d(boundedCurve)) {
            return boundedCurve.normal;
        }
    }
    return undefined;
}
function getNormalByX(xAxis) {
    if (xAxis.isParallel(_types__WEBPACK_IMPORTED_MODULE_0__.dummyVector3d)) {
        if (xAxis.z > 0) {
            return GeomLib.createVector3d(-1, 0, 0);
        }
        else {
            return GeomLib.createVector3d(1, 0, 0);
        }
    }
    else {
        return xAxis.cross(_types__WEBPACK_IMPORTED_MODULE_0__.dummyVector3d.cross(xAxis)).normalized();
    }
}
function generatePathPoses(path) {
    const pathPointPoses = [];
    let accumulateLength = 0;
    for (let i = 0; i < path.length; i++) {
        const pathObject = path[i];
        const discretePoints = discreteAuxiliaryBoundedCurve(pathObject.curve);
        if (discretePoints.length) {
            const boundedCurveNormal = getAuxiliaryBoundedCurveNormal(pathObject.curve);
            for (let j = 0; j < discretePoints.length; j++) {
                const discretePoint = discretePoints[j];
                if (j === 0) {
                    if (i === 0) {
                        const nextDiscretePoint = discretePoints[j + 1];
                        pathPointPoses.push({ point: discretePoints[0], direction: nextDiscretePoint.subtracted(discretePoint).normalized(), accumulateLength });
                    }
                }
                else {
                    const prevDiscretePoint = discretePoints[j - 1];
                    const direction = discretePoint.subtracted(prevDiscretePoint).normalized();
                    const segmentLength = prevDiscretePoint.distanceTo(discretePoint);
                    accumulateLength += segmentLength;
                    pathPointPoses.push({ point: discretePoint, direction, accumulateLength });
                }
                pathPointPoses[pathPointPoses.length - 1].normal = boundedCurveNormal ? boundedCurveNormal : getNormalByX(pathPointPoses[pathPointPoses.length - 1].direction);
            }
        }
    }
    return { pathPointPoses, totalLength: accumulateLength };
}
function getTransformFromPathPointPoses(pathPointPoses, params) {
    const { count, interval, scale, pathAxis, normalAxis } = params;
    const componentTransforms = [];
    const scaleMatrix = GeomLib.createScaleMatrix4(scale.value, scale.value, scale.value);
    let componentIndex = 0;
    let componentPositionLength = componentIndex * interval.value;
    for (let k = 0; k < pathPointPoses.length; k++) {
        const { point, normal, direction, accumulateLength } = pathPointPoses[k];
        const prevAccumulateLength = k === 0 ? -1 : pathPointPoses[k - 1].accumulateLength;
        let componentTransform;
        const pathNormal = normal || _types__WEBPACK_IMPORTED_MODULE_0__.dummyVector3d;
        let ccsX;
        let ccsY;
        let ccsZ;
        switch (pathAxis) {
            case "X" /* Axis.X */:
                ccsX = direction;
                break;
            case "-X" /* Axis.XMinus */:
                ccsX = direction.reversed();
                break;
            case "Y" /* Axis.Y */:
                ccsY = direction;
                break;
            case "-Y" /* Axis.YMinus */:
                ccsY = direction.reversed();
                break;
            case "Z" /* Axis.Z */:
                ccsZ = direction;
                break;
            case "-Z" /* Axis.ZMinus */:
                ccsZ = direction.reversed();
                break;
        }
        switch (normalAxis) {
            case "X" /* Axis.X */:
                ccsX = pathNormal;
                break;
            case "-X" /* Axis.XMinus */:
                ccsX = pathNormal.reversed();
                break;
            case "Y" /* Axis.Y */:
                ccsY = pathNormal;
                break;
            case "-Y" /* Axis.YMinus */:
                ccsY = pathNormal.reversed();
                break;
            case "Z" /* Axis.Z */:
                ccsZ = pathNormal;
                break;
            case "-Z" /* Axis.ZMinus */:
                ccsZ = pathNormal.reversed();
                break;
        }
        if (!ccsX) {
            ccsX = ccsY.cross(ccsZ);
        }
        if (!ccsY) {
            ccsY = ccsZ.cross(ccsX);
        }
        if (!ccsZ) {
            ccsZ = ccsX.cross(ccsY);
        }
        while (componentIndex < count.value && componentPositionLength > prevAccumulateLength && componentPositionLength <= accumulateLength) {
            const componentPosition = point.added(direction.multiplied(componentPositionLength - accumulateLength));
            componentTransform = GeomLib.createTranslationMatrix4(componentPosition.x, componentPosition.y, componentPosition.z)
                .multiplied(GeomLib.createAlignCCSMatrix4(ccsX, ccsY, ccsZ, _types__WEBPACK_IMPORTED_MODULE_0__.dummyPoint3d))
                .multiplied(scaleMatrix);
            componentTransforms.push(componentTransform);
            componentIndex++;
            componentPositionLength = componentIndex * interval.value;
        }
    }
    return componentTransforms;
}
function getBoundingBoxSizeInWorld(groupInstance) {
    const localBoundingBox = groupInstance.getLocalBoundingBox();
    const transform = groupInstance.getTransform();
    const oldSize = [GeomLib.createVector3d(localBoundingBox.width, 0, 0), GeomLib.createVector3d(0, localBoundingBox.height, 0), GeomLib.createVector3d(0, 0, localBoundingBox.depth)];
    return oldSize.map(vec => vec.appliedMatrix4(transform).length);
}
function getExtendedTransform() {
    const design = app.getActiveDesign();
    const editPath = design.getEditPath();
    const extendedTransform = GeomLib.createIdentityMatrix4();
    for (const path of editPath) {
        extendedTransform.multiply(path.getTransform());
    }
    return extendedTransform;
}
function findPathAfterMakeGroup(path, newGroupInstance) {
    var _a;
    const auxiliaryBoundedCurves = [];
    (_a = newGroupInstance.getGroupDefinition()) === null || _a === void 0 ? void 0 : _a.getAuxiliaryCurves().forEach(curve => {
        if (isKAuxiliaryBoundedCurve(curve)) {
            auxiliaryBoundedCurves.push(curve);
        }
    });
    const newPath = [];
    for (const { curve, reversed } of path) {
        const startPoint = curve.getStartVertex().getPoint();
        const endPoint = curve.getEndVertex().getPoint();
        const newCurveIndex = auxiliaryBoundedCurves.findIndex(newCurve => {
            const newStartPoint = newCurve.getStartVertex().getPoint();
            const newEndPoint = newCurve.getEndVertex().getPoint();
            if (newStartPoint.isEqual(startPoint) && newEndPoint.isEqual(endPoint)) {
                return true;
            }
            return false;
        });
        if (newCurveIndex > -1) {
            newPath.push({ curve: auxiliaryBoundedCurves[newCurveIndex], reversed });
            auxiliaryBoundedCurves.splice(newCurveIndex, 1);
        }
        else {
            return undefined;
        }
    }
    return newPath;
}


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
/*!**************************!*\
  !*** ./src/main/main.ts ***!
  \**************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _PathArrayParamsEditTool__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./PathArrayParamsEditTool */ "./src/main/PathArrayParamsEditTool.ts");
/* harmony import */ var _PathArrayTool__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./PathArrayTool */ "./src/main/PathArrayTool.ts");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils */ "./src/main/utils.ts");
var __awaiter = (undefined && undefined.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};



const pluginUI = app.getPluginUI();
pluginUI.resize(240, 700);
pluginUI.mount();
let activatedCustomTool;
function onUIMessage(data) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            if (data.type === 'activatePathArray') {
                app.activateCustomTool(_PathArrayTool__WEBPACK_IMPORTED_MODULE_1__.pathArrayTool, false);
                activatedCustomTool = _PathArrayTool__WEBPACK_IMPORTED_MODULE_1__.pathArrayTool;
            }
            else if (data.type === 'deActivatePathArray') {
                app.deactivateCustomTool(_PathArrayTool__WEBPACK_IMPORTED_MODULE_1__.pathArrayTool);
                activatedCustomTool = undefined;
            }
            else if (data.type === 'pathArrayParamsChange') {
                if (activatedCustomTool !== _PathArrayParamsEditTool__WEBPACK_IMPORTED_MODULE_0__.pathArrayParamsEditTool) {
                    app.activateCustomTool(_PathArrayParamsEditTool__WEBPACK_IMPORTED_MODULE_0__.pathArrayParamsEditTool, false);
                    activatedCustomTool = _PathArrayParamsEditTool__WEBPACK_IMPORTED_MODULE_0__.pathArrayParamsEditTool;
                }
                setTimeout(() => __awaiter(this, void 0, void 0, function* () {
                    const value = data.value;
                    let paramsChangeResult;
                    if (data.subType === 'intervalChange') {
                        paramsChangeResult = yield _PathArrayParamsEditTool__WEBPACK_IMPORTED_MODULE_0__.pathArrayParamsEditTool.updateInterval(value);
                    }
                    else if (data.subType === 'countChange') {
                        paramsChangeResult = yield _PathArrayParamsEditTool__WEBPACK_IMPORTED_MODULE_0__.pathArrayParamsEditTool.updateCount(value);
                    }
                    else if (data.subType === 'scaleChange') {
                        paramsChangeResult = yield _PathArrayParamsEditTool__WEBPACK_IMPORTED_MODULE_0__.pathArrayParamsEditTool.updateScale(value);
                    }
                    else if (data.subType === 'pathAxisChange') {
                        paramsChangeResult = yield _PathArrayParamsEditTool__WEBPACK_IMPORTED_MODULE_0__.pathArrayParamsEditTool.updatePathAxis(value);
                    }
                    else if (data.subType === 'normalAxisChange') {
                        paramsChangeResult = yield _PathArrayParamsEditTool__WEBPACK_IMPORTED_MODULE_0__.pathArrayParamsEditTool.updateNormalAxis(value);
                    }
                    if (paramsChangeResult) {
                        pluginUI.postMessage({ type: 'pathArrayParamsChanged', pathArrayParams: _PathArrayParamsEditTool__WEBPACK_IMPORTED_MODULE_0__.pathArrayParamsEditTool.getPathArrayParams() });
                    }
                    app.deactivateCustomTool(_PathArrayParamsEditTool__WEBPACK_IMPORTED_MODULE_0__.pathArrayParamsEditTool, false);
                    activatedCustomTool = undefined;
                }), 150);
            }
        }
        catch (error) {
            console.error(error);
            closePlugin();
        }
    });
}
pluginUI.onMessage(onUIMessage);
const selection = app.getSelection();
selection.addObserver({
    onSelectionChange: () => {
        if (activatedCustomTool !== _PathArrayParamsEditTool__WEBPACK_IMPORTED_MODULE_0__.pathArrayParamsEditTool) {
            const allEntities = selection.getAllEntities();
            if (allEntities.length === 1 && (0,_utils__WEBPACK_IMPORTED_MODULE_2__.isKGroupInstance)(allEntities[0])) {
                const isPathArrayModel = _PathArrayParamsEditTool__WEBPACK_IMPORTED_MODULE_0__.pathArrayParamsEditTool.setModel(allEntities[0]);
                if (isPathArrayModel) {
                    pluginUI.postMessage({ type: 'pathArrayParamsChanged', pathArrayParams: _PathArrayParamsEditTool__WEBPACK_IMPORTED_MODULE_0__.pathArrayParamsEditTool.getPathArrayParams() });
                    return;
                }
            }
            _PathArrayParamsEditTool__WEBPACK_IMPORTED_MODULE_0__.pathArrayParamsEditTool.clearModel();
            pluginUI.postMessage({ type: 'pathArrayParamsChanged', pathArrayParams: undefined });
        }
    }
});
function onPluginStartUp() {
    const allEntities = selection.getAllEntities();
    if (allEntities.length === 1 && (0,_utils__WEBPACK_IMPORTED_MODULE_2__.isKGroupInstance)(allEntities[0])) {
        const isPathArrayModel = _PathArrayParamsEditTool__WEBPACK_IMPORTED_MODULE_0__.pathArrayParamsEditTool.setModel(allEntities[0]);
        if (isPathArrayModel) {
            pluginUI.postMessage({ type: 'pathArrayParamsChanged', pathArrayParams: _PathArrayParamsEditTool__WEBPACK_IMPORTED_MODULE_0__.pathArrayParamsEditTool.getPathArrayParams() });
        }
    }
}
onPluginStartUp();

})();

/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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